/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.wizard.exe;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.ui.pathmapper.PathMappingComposite;
import org2.eclipse.php.internal.debug.ui.wizard.CompositeFragment;
import org2.eclipse.php.internal.debug.ui.wizard.IControlHandler;
import org2.eclipse.php.internal.debug.ui.wizard.exe.PHPExeEditDialog;

public class PathMapperCompositeFragment
extends CompositeFragment {
    private PathMappingComposite pathMapperComposite;

    public PathMapperCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.controlHandler.setTitle("PHP Executable Path Mapping");
        this.controlHandler.setDescription("Specify mapping between PHP executable relative and local paths");
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.editor.php.epl", (String)"/icons/full/wizban/phpexe_wiz.gif");
        this.controlHandler.setImageDescriptor(imageDescriptor);
        this.setDisplayName("Path Mapping");
        this.setTitle("Edit PHP Executable Path Mapping");
        this.setDescription("Configure PHP Executable Path Mapping");
        if (isForEditing) {
            this.setData(((PHPExeEditDialog)this.controlHandler).getPHPExeItem());
        }
        this.createControl(isForEditing);
    }

    protected void createControl(boolean isForEditing) {
        GridLayout pageLayout = new GridLayout();
        this.setLayout((Layout)pageLayout);
        Composite composite = new Composite((Composite)this, 0);
        pageLayout.numColumns = 1;
        composite.setLayout((Layout)pageLayout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.pathMapperComposite = new PathMappingComposite(composite, 0);
        data = new GridData(1808);
        this.pathMapperComposite.setLayoutData(data);
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
    }

    protected void init() {
        PathMapper pathMapper;
        if (this.pathMapperComposite == null || this.pathMapperComposite.isDisposed()) {
            return;
        }
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem != null && (pathMapper = PathMapperRegistry.getByPHPExe(phpExeItem)) != null) {
            this.pathMapperComposite.setData(pathMapper.getMapping());
        }
    }

    protected void validate() {
        this.setMessage(this.getDescription(), 0);
        this.setComplete(true);
        this.controlHandler.update();
    }

    protected void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        this.setComplete(type != 3);
        this.controlHandler.update();
    }

    @Override
    public boolean performOk() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem != null) {
            PathMapper pathMapper = PathMapperRegistry.getByPHPExe(phpExeItem);
            pathMapper.setMapping(this.pathMapperComposite.getMappings());
            PathMapperRegistry.storeToPreferences();
        }
        return true;
    }

    @Override
    public void setData(Object phpExeItem) {
        if (phpExeItem != null && !(phpExeItem instanceof PHPexeItem)) {
            throw new IllegalArgumentException("The given object is not a PHPExeItem");
        }
        super.setData(phpExeItem);
        this.init();
        this.validate();
    }

    public PHPexeItem getPHPExeItem() {
        return (PHPexeItem)this.getData();
    }
}

